<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormEditCategory()
  ===================================================*/

  function ShowFormEditCategory() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $name, $description, $image, $content, $meta_keyword, 
             $meta_description, $order_num, $parent, $visible, $permission, 
             $registered_only, $header, $footer, $related, $page_title,
             $price_sponsored, $price_premium, $price_basic;


    // get current value

    $query = "select * from idx_category where category_id = '$id'";
    $result = $dbConn->Execute($query);

    $parent_id = htmlspecialchars($result->Fields("parent_id"));
    $name = htmlspecialchars($result->Fields("name"));
    $description = htmlspecialchars($result->Fields("description"));
    $image = htmlspecialchars($result->Fields("image"));
    $content = htmlspecialchars($result->Fields("content"));
    $visible = htmlspecialchars($result->Fields("visible"));
    $meta_keyword = htmlspecialchars($result->Fields("meta_keyword"));
    $meta_description = htmlspecialchars($result->Fields("meta_description"));
    $permission = $result->Fields("permission");
    $registered_only = $result->Fields("registered_only");
    $header = htmlspecialchars($result->Fields("header"));
    $footer = htmlspecialchars($result->Fields("footer"));
    $related = $result->Fields("related");
    $page_title = htmlspecialchars($result->Fields("page_title"));
    $order_num = $result->Fields("order_num");
    $price_sponsored = $result->Fields("sponsored_price");
    $price_premium = $result->Fields("premium_price");
    $price_basic = $result->Fields("basic_price");

    // prepare for template

    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->separator = $category_separator;

    $parent = $category_obj->DisplayCategoryListBox($parent_id,'true',1);
    $related = str_replace("<select name=\"cat\">","<select name=\"related\">",$category_obj->DisplayCategoryListBox($related,'true',1));
    $related = str_replace("Main Category","Have no relation",$related);


    $visible = ShowRadioButton("visible",$msg["20011"],$msg["20012"],$visible);
    $permission = ShowDropDown("permission",$msg["20013"],$msg["20014"],$permission);
    $registered_only = ShowRadioButton("registered_only",$msg["20015"],$msg["20016"],$registered_only);

    DisplayTemplate($admin_template_path . "cat_edit_form.html",
      "\$name,\$description,\$image,\$content,\$meta_keyword,\$meta_description,\$order_num,".
      "\$parent,\$visible,\$permission,\$registered_only,\$id,\$header,\$footer,\$related,\$page_title,\$price_sponsored,\$price_premium,\$price_basic");
  }


  /*===================================================
    ProcessFormEditCategory()
  ===================================================*/

  function ProcessFormEditCategory() {

    // vars global configuration
    global $category_separator, $admin_template_path;

    // vars url & form
    global $id, $name, $cat, $description, $image, $content, $visible, 
             $permission, $order_num, $meta_keyword, $meta_description, 
             $registered_only, $header, $footer, $related, $page_title,
             $price_sponsored, $price_premium, $price_basic;

    // vars messages
    global $msg;

    // vars template
    global $message, $back;

    // verify input

    if(empty($name)) $error_msg = $msg["20021"];

    if(empty($error_msg)) {

      $category_obj = new clsCategory;
      $category_obj->table_name = "idx_category";
      $category_obj->separator = $category_separator;
      $parent_id = $cat;
      $category_obj->Edit($id, $name, $parent_id, $description, $image, 
                            $content, $visible, $permission, $meta_keyword, 
                            $meta_description, $registered_only, $header, 
                            $footer, $related, $page_title, $order_num, 
                            $price_sponsored, $price_premium, $price_basic);

      $message = $msg["20051"] . $msg["30016"];

      if($visible==0) $category_obj->HideChildren($id);
      elseif($visible==1) $category_obj->UnhideChildren($id);

      if($registered_only==0) $category_obj->UnsetMemberOnlyToChildren($id);
      elseif($registered_only==1) $category_obj->SetMemberOnlyToChildren($id);

    }
    else $message = $error_msg;

    $back = "<a href=cat_view.php>Back</a>";

    DisplayTemplate($admin_template_path . "message.html", "\$message,\$back");

  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  if (empty($pflag)) {
    ShowFormEditCategory();
  }
  elseif ($pflag == 'edit') {
    ProcessFormEditCategory();
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>